#include "MakeBook.inc"
#include "MakeShelf.inc"
#include "MakeLibrary.inc"

#declare rd=seed(0); // seed

#declare xLib=1.5; // library width
#declare yLib=4; // library height
#declare zShelf=0.3; // depth of shelves
#declare zLibShelf=0.3; // depth of the side planks (>zShelf)
#declare zLibPanel=0.5; // depth of bottom panels
#declare ePlankShelf=0.025; // thickness of shelf plank
#declare ePlankSide=0.03; // thickness of side plank
#declare ePlankTop=0.06; // thickness of top and main horizontal planks  
#declare yLibPanel=0.8; // height of bottom panel
#declare yPlinth=0.2; // height of bottom plinth
#declare sdyShelf=0.2;  // pseudo standard deviation of shelf height (-sdyShelf*h/2 to +sdShelf*h/2)
#declare xBook=0.08; // Book thickness
#declare sdxBook=0.03;  // pseudo standard deviation of book thickness (-sdxBook*xBook/2 to +sdxBook*xBook/2)
#declare sdyBook=0.08;  // pseudo standard deviation of book height
#declare sdzBook=0.06;  // pseudo standard deviation of book depth
#declare typeShelf=0;     // by series
#declare typeBook=0;     // old books
#declare slackShelf=0;  // no slack

#declare colLib=rgb<71,31,5>/255;
#declare txtLib=texture{
        pigment{
                wood         
                turbulence 0.2
                lambda 3
                rotate x*-80
                rotate z*-20
                scale 0.1*<1,8,1>*0.7
                color_map{
                        [0 colLib*1.1]
                        [1 colLib*0.6]
                }
                        
        }        
        finish{ambient 0.01 diffuse 0.6 specular 0.4 roughness 0.01}
}        

#declare doBooks=true; // creates the books
//#declare doBooks=false; // does not create the books
#declare Bibli = union{

        #declare nShelf=5; // number of shelves
        #declare nSetMax=4;     // maximum number of book sets
        #declare slackShelf=1;  // very slack
        object{mLibrary(xLib*0.9,yLib,zLibShelf,zLibPanel,yLibPanel,yPlinth,nShelf,sdyShelf,ePlankShelf,xBook,sdxBook,sdyBook,sdzBook,typeShelf,typeBook,slackShelf,nSetMax,doBooks,txtLib)}
        
        #declare nShelf=5;
        #declare nSetMax=4;
        #declare slackShelf=1.5;  // lot of slack
        object{mLibrary(xLib*1.2,yLib,zLibShelf,zLibPanel,yLibPanel,yPlinth,nShelf,sdyShelf,ePlankShelf,xBook,sdxBook,sdyBook,sdzBook,typeShelf,typeBook,slackShelf,nSetMax,doBooks,txtLib) translate x*0.9*xLib}
        
        #declare nShelf=5;
        #declare nSetMax=3;
        #declare slackShelf=0.5;  // almost no slack
        object{mLibrary(xLib*1.3,yLib,zLibShelf,zLibPanel,yLibPanel,yPlinth,nShelf,sdyShelf,ePlankShelf,xBook,sdxBook,sdyBook,sdzBook,typeShelf,typeBook,slackShelf,nSetMax,doBooks,txtLib) translate x*2.1*xLib}

        texture{txtLib}
        rotate y*30
}
                          